# ProbabilisticADMGs



### To reproduce the results in Figure 3:
1. Run ```python3 testbed.py```  for HEID-1, HEID-2, MCIP-H1, MCIP-H1, MCIP-exact
2. Run ```python3 testbed_brutev3.py```   for EDGEID. This uses the HEID-1 and -2 results from step 1. to constrain the search space for EDGEID
3. View results using jupyter notebook ```results_exactraction_noinf.ipynb```

### To reproduce the results in Table 1:
```python3 real_world_evals.py```

### For additional results in appendix (Figure 6): 
1. Edit lines 196  of ```testbed.py``` and line 236 of ```testbed_brutev3.py``` to:
```python
sparsity = False  # removes sparsity constraint
```
2. Run ```testbed.py ``` for HEID-1, HEID-2, MCIP-H1, MCIP-H1, MCIP-exact
3. Run ```python3 testbed_brutev3.py``` for EDGEID. This uses the HEID-1 and -2 results from step 1. to constrain the search space for EDGEID
4. Use the jupyter notebook ```results_exactraction_noinf.ipynb``` to explore results (change results filenames if needed).


### Matlab Version
A Matlab implementation of EDGEID (exact algorithm) is included in the 'matlab_implementation' folder.

### Requirements:
```python==3.7.12```
 
Packages:

```
networkx==2.6.3
pandas==1.2.5
numpy==1.20.3
matplotlib==3.5.1
tqdm==4.62.3
bnlearn==0.6.3
jupyter==6.4.6
```